echo off
CLS

REM --------------------------------------------------------------------------------------------------------
REM Section 1 - Tell the user to unhook all livescans

echo Ensure that all i3 livescan devices are disconnected from the computer.
pause

REM --------------------------------------------------------------------------------------------------------
REM Section 2 - Assign variables that will be used for copying files to/from
REM
REM VARIABLES - Change the value of newsubFolder to change the folder into which files will be copied
REM           - this folder will be located in the Program Files directory for the given architecture
REM           - Change the value of sourceFolder if you are changing the location of the folder from
REM           - which files are going to be copied. The default is the desktop of the current user in
REM           - the i3Files folder. NOTE: you can also change the files that are in the i3Files folder
REM           - to alter the versions of the files that exist in the folder

SET newsubFolder=\Identification International\TestUtilities
SET sourceFolder="%~dp0i3Files"

REM --------------------------------------------------------------------------------------------------------
REM Section 3 - Determine the version of the OS that is being used using windows Version numbers

For /f "tokens=2 delims=[]" %%G in ('ver') Do (set _version=%%G) 

For /f "tokens=2,3,4 delims=. " %%G in ('echo %_version%') Do (set _major=%%G& set _minor=%%H& set /a _build=%%I) 

REM 7601 is the build number of Windows 7 and we should not support anything earlier than this
REM 10240 is the build number of the first Windows 10 and Windows 10 and 11 will have different
REM installation protocol than Windows 7, 8, and 8.1

if %_build% LSS 7601 (
	GOTO OS_TO_OLD
) 

if %_build% GEQ 10240 (SET osVersion="10 or Later") else (SET osVersion="7, 8, or 8.1")

REM --------------------------------------------------------------------------------------------------------
REM Section 4 - check to see if the script was run with admin rights
REM
REM Check to see if the next command can be run. If not, then the current user is not an admin.

%systemroot%\system32\fsutil.exe dirty query %systemdrive% >nul 2>&1

if %errorLevel%==0 (
	GOTO StartScript
) else (
        GOTO AdminError
)

:StartScript

REM --------------------------------------------------------------------------------------------------------
REM Section 5 - see if the architecture is 32 or 64 bit

if "%PROCESSOR_ARCHITECTURE%"=="AMD64" GOTO 64BIT   
REM 32BIT
SET createFolder="c:\Program Files%newsubFolder%"
SET enviroFolder=c:\Program Files%newsubFolder%
GOTO ENDPROC
:64BIT
REM 64BIT
SET createFolder="c:\Program Files (x86)%newsubFolder%"
SET enviroFolder=c:\Program Files (x86)%newsubFolder%
:ENDPROC

REM --------------------------------------------------------------------------------------------------------
REM Section 6 - make the folder to put the files into then look at the error state to take action
REM             if the folder could not be created

md %createFolder% >nul 2>&1

REM If the folder already existed

if %errorLevel%==1 (
    	GOTO copyFiles
)

REM The folder did not exist and the folder could not be created

if NOT %errorlevel%==0 (
   	GOTO CreateError
)

:copyFiles

if not exist %sourceFolder% (
	GOTO SourceFolderError
)

REM --------------------------------------------------------------------------------------------------------
REM Section 7 - clean out the folder and then copy files into it
REM
REM Clean out the destination folder first. The idea is that we do not want to put inconsistent files
REM in the folder as we assume that every set of files in i3Files is a consistent set that is perhaps
REM inconsistent with the set already in the folder

erase /F /Q %createFolder%

%systemroot%\system32\xcopy /s /h /y %sourceFolder% %createFolder%

REM --------------------------------------------------------------------------------------------------------
REM Section 8 - append to the PATH variable is the PATH does not already contain the data to be added
REM             There is a difference in how this is handled between XP and newer OS versions

setlocal EnableDelayedExpansion

REM Check if enviroFolder is not already in system path and add it if it is not
REM See above comment for what OS versions are are included in each case
REM Finally, install the certificates (for silent install) then drivers for 
REM version A, B and C i3 livescans

set "pathtoInsert=%enviroFolder%"

if %osVersion%=="10 or Later" (
	if "!PATH:%pathtoInsert%=!" equ "%PATH%" (
   		%systemroot%\system32\setx PATH /M "%PATH%;%pathtoInsert%"
	)
	"%enviroFolder%\digIDDrivers3.exe" -ai -! -v ABC
	GOTO nextStep
) 

REM Must be 7, 8, or 8.1

if "!PATH:%pathtoInsert%=!" equ "%PATH%" (
   	%systemroot%\system32\setx PATH /M "%PATH%;%pathtoInsert%"
)

"%enviroFolder%\digIDDrivers3.exe" -ai3
"%enviroFolder%\digIDDrivers3.exe" -ai6 -! -v ABC

:nextStep

REM This errorLevel will be set if an executable cannot be found. Presumably this
REM would only be digIDDrivers3 since the others are system commands that we assume
REM are present.  If the executables were found we assume execution completed properly 
REM and the i3Files directory is removed to indicate final completion.

if %errorLevel%==9009 (
	GOTO NoDriverInstaller
) 

REM --------------------------------------------------------------------------------------------------------
REM Section 9 - erase the folder from which files are copied and then the folder. Indicates success.

erase /F /Q %sourceFolder%
rmdir %sourceFolder%

echo Please shutdown your computer and then power it on for the new path definition to take effect.
pause 

GOTO Exit

REM --------------------------------------------------------------------------------------------------------
REM Section 10 - These are the error conditions that could happen that should be presented to the user.

:AdminError
echo Fail: script must be "Run as administrator". Right click on the batch file 
echo and select run as administrator. 
 
pause 
GOTO Exit

:SourceFolderError
echo Fail: source folder does not exist - did you copy i3Files from the zip file?
pause
GOTO Exit

:CreateError
echo Fail: could not create %createFolder% folder
pause
GOTO Exit

:NoDriverInstaller
echo Fail: could not run digIDDrivers3.exe. Is it present in the i3Files folder?
pause
GOTO Exit

:OS_TO_OLD
echo Fail: build %_build% of the operating system is too old for use of these drivers.
pause
GOTO Exit

:Exit
